#ifndef __CClip__
#define __CClip__

#include "../Graphics/CNativeImage.hpp"
using Exponent::GUI::Graphics::CNativeImage;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Windowing
		{
			/**
			 * @class CClip CClip.hpp
			 * @brief Applies clipping functions to the GUI
			 *
			 * @date 02/10/2004
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CClip.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			class CClip
			{
			public:

//	===========================================================================

				/**
				 * Construction
				 */
				CClip();

				/**
				 * Destruction
				 */
				virtual ~CClip();

//	===========================================================================

				/**
				 * Initialise
				 * @param image The native drawing image
				 * @param area The total onscreen window area
				 * @param context On Mac must be the quartz context we are associated with, on PC can be null
				 */
				void initialise(CNativeImage *image, const CRect &area, void *context = NULL);

				/**
				 * Uninitialise
				 */
				void uninitialise();

//	===========================================================================

				/**
				 * Get the current clipping region
				 * @param area On return filled with the current clipping area
				 */
				void getCurrentClipRegion(CRect &area);
				
				/**
				 * Get the current clipping regiion
				 * @retval const CRect& The current global clipping position
				 */
				const CRect &getCurrentClipRegion() const { return m_currentClip; }

				/**
				 * Set teh current clipping region
				 * @param area The actual window position to clip 
				 */
				void setCurrentClipRegion(const CRect &area);

//	===========================================================================

				/**
				 * Clear the clipping region
				 */
				void clearClipRegion();

				/**
				 * Is it currently clipped
				 * @retval bool True if display is clipped, false otherwise
				 */
				bool displayIsClipped() { return m_isClipped; }

//	===========================================================================

			protected:

//	===========================================================================

				bool m_isClipped;							/**< Are we currently clipped */
				CRect m_area;								/**< The total area */
				CRect m_currentClip;						/**< Current clipping area */
				CNativeImage *m_image;						/**< The native draw image */
				bool m_initialised;							/**< Are we initialised */
				/** @cond */
				#ifndef WIN32
				/** @endcond */
					CGContextRef m_theContext;				/**< Quartz context */
				/** @cond */
				#endif
				/** @endcond */
			};
		}
	}
}
#endif	// End of CClip.hpp